document.querySelectorAll('button').forEach(button => {
  button.addEventListener('click', () => {
    const sp = button.getAttribute('data-sp');
    
    chrome.tabs.query({active: true, currentWindow: true}, (tabs) => {
      const tab = tabs[0];
      if (!tab || !tab.url) return;

      try {
        const url = new URL(tab.url);
        if (url.hostname.includes('youtube.com') && url.pathname === '/results') {
          url.searchParams.set('sp', decodeURIComponent(sp));
          chrome.tabs.update(tab.id, {url: url.toString()});
        } else {
          const originalText = button.innerText;
          button.innerText = "Search results only";
          button.style.color = "#ff4e4e";
          setTimeout(() => {
            button.innerText = originalText;
            button.style.color = "";
          }, 1500);
        }
      } catch (e) {
        console.error("Invalid URL");
      }
    });
  });
});